/*
 * (c) Copyright 2001 MyCorporation.
 * All Rights Reserved.
 */
package com.ibm.lab.soln.junit.money;

import junit.framework.TestCase;

/**
 * @version 	1.0
 * @author
 */
public class MoneyBagTest extends TestCase {
	private Money f12CHF;
	private Money f14CHF;
	private Money f7USD;
	private Money f21USD;

	private MoneyBag fMB1;
	private MoneyBag fMB2;

	/**
	 * Constructor for MoneyBagTest.
	 * @param arg0
	 */
	public MoneyBagTest(String arg0) {
		super(arg0);
	}
	protected void setUp() {
		f12CHF = new Money(12, "CHF");
		f14CHF = new Money(14, "CHF");
		f7USD = new Money(7, "USD");
		f21USD = new Money(21, "USD");

		fMB1 = new MoneyBag(f12CHF, f7USD);
		fMB2 = new MoneyBag(f14CHF, f21USD);
	}
	public void testBagMultiply() {
		// {[12 CHF][7 USD]} *2 == {[24 CHF][14 USD]}
		Money bag[] = { new Money(24, "CHF"), new Money(14, "USD")};
		MoneyBag expected = new MoneyBag(bag);
		assertEquals(expected, fMB1.multiply(2));
		assertEquals(fMB1, fMB1.multiply(1));
		assertTrue(fMB1.multiply(0).isZero());
	}
	public void testBagSimpleAdd() {
		// {[12 CHF][7 USD]} + [14 CHF] == {[26 CHF][7 USD]}
		Money bag[] = { new Money(26, "CHF"), new Money(7, "USD")};
		MoneyBag expected = new MoneyBag(bag);
		assertEquals(expected, fMB1.add(f14CHF));
	}
	public void testBagSubtract() {
		// {[12 CHF][7 USD]} - {[14 CHF][21 USD] == {[-2 CHF][-14 USD]}
		Money bag[] = { new Money(-2, "CHF"), new Money(-14, "USD")};
		MoneyBag expected = new MoneyBag(bag);
		assertEquals(expected, fMB1.subtract(fMB2));
	}
	public void testMixedSimpleAdd() {
		// [12 CHF] + [7 USD] == {[12 CHF][7 USD]}
		Money bag[] = { f12CHF, f7USD };
		MoneyBag expected = new MoneyBag(bag);
		assertEquals(expected, f12CHF.add(f7USD));
	}
	public void testSimpleBagAdd() {
		// [14 CHF] + {[12 CHF][7 USD]} == {[26 CHF][7 USD]}
		Money bag[] = { new Money(26, "CHF"), new Money(7, "USD")};
		MoneyBag expected = new MoneyBag(bag);
		assertEquals(expected, f14CHF.add(fMB1));
	}

}